WITH
EXEC_STATS AS
(
SELECT database_id, type_desc, object_id,
       NULL AS parent_object, sql_handle, plan_handle,
       execution_count, total_worker_time
FROM   sys.dm_exec_procedure_stats
UNION  ALL
SELECT NULL, 'QUERY', NULL,
       NULL, sql_handle, plan_handle,
       execution_count, total_worker_time
FROM   sys.dm_exec_query_stats
UNION ALL
SELECT database_id, ts.type_desc, ts.object_id,
       s.name + '.' + op.name AS parent_object,
       sql_handle, plan_handle,
       execution_count, total_worker_time
FROM   sys.dm_exec_trigger_stats AS ts
       INNER JOIN sys.objects AS o
             ON ts.object_id = o.object_id
       INNER JOIN sys.objects AS op
             ON o.parent_object_id = op.object_id
             INNER JOIN sys.schemas AS s
                   ON op.schema_id = s.schema_id)
SELECT TOP 10 database_id, type_desc, object_id,
       parent_object, execution_count, total_worker_time,
       q.text AS SQL_command, p.query_plan
FROM   EXEC_STATS
       OUTER APPLY sys.dm_exec_sql_text(sql_handle) AS q
       OUTER APPLY sys.dm_exec_query_plan(plan_handle) AS p
ORDER BY total_worker_time DESC;
--> ATENTION, cette requte ne fonctionne pas dans la version 2005 (les DMV sys.dm_exec_..._stats n'existent pas)